/*
 * Copyright (c) 2008, Movenda S.p.A. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice, this list
 * of conditions and the following disclaimer. Redistributions in binary form must
 * reproduce the above copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided with the
 * distribution. Neither the name of the Movenda S.p.A. nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission. THIS SOFTWARE IS PROVIDED BY
 * THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "stdint.h"

#define _RGBY(i) { \
(int16_t)(1.164 * 64 * (i-16) + 0.5), \
(int16_t)(1.164 * 64 * (i-16) + 0.5), \
(int16_t)(1.164 * 64 * (i-16) + 0.5), \
(int16_t)0x0000 \
}

#define _RGBU(i) { \
(int16_t)(2.018 * 64 * (i - 128) + 0.5), \
(int16_t)0x0000, \
(int16_t)(-0.391 * 64 * (i - 128) + 0.5), \
(int16_t)0x0000 \
}

#define _RGBV(i) { \
(int16_t)0x0000, \
(int16_t)(1.596 * 64 * (i - 128) + 0.5), \
(int16_t)(-0.813 * 64 * (i - 128) + 0.5), \
(int16_t)0x0000 \
}

const int16_t __attribute__ ((aligned (4))) RGBYUV[768][4] = {

_RGBY(0x10),_RGBY(0x10),_RGBY(0x10),_RGBY(0x10),
_RGBY(0x10),_RGBY(0x10),_RGBY(0x10),_RGBY(0x10),
_RGBY(0x10),_RGBY(0x10),_RGBY(0x10),_RGBY(0x10),
_RGBY(0x10),_RGBY(0x10),_RGBY(0x10),_RGBY(0x10),
_RGBY(0x10),_RGBY(0x11),_RGBY(0x12),_RGBY(0x13),
_RGBY(0x14),_RGBY(0x15),_RGBY(0x16),_RGBY(0x17),
_RGBY(0x18),_RGBY(0x19),_RGBY(0x1A),_RGBY(0x1B),
_RGBY(0x1C),_RGBY(0x1D),_RGBY(0x1E),_RGBY(0x1F),
_RGBY(0x20),_RGBY(0x21),_RGBY(0x22),_RGBY(0x23),
_RGBY(0x24),_RGBY(0x25),_RGBY(0x26),_RGBY(0x27),
_RGBY(0x28),_RGBY(0x29),_RGBY(0x2A),_RGBY(0x2B),
_RGBY(0x2C),_RGBY(0x2D),_RGBY(0x2E),_RGBY(0x2F),
_RGBY(0x30),_RGBY(0x31),_RGBY(0x32),_RGBY(0x33),
_RGBY(0x34),_RGBY(0x35),_RGBY(0x36),_RGBY(0x37),
_RGBY(0x38),_RGBY(0x39),_RGBY(0x3A),_RGBY(0x3B),
_RGBY(0x3C),_RGBY(0x3D),_RGBY(0x3E),_RGBY(0x3F),
_RGBY(0x40),_RGBY(0x41),_RGBY(0x42),_RGBY(0x43),
_RGBY(0x44),_RGBY(0x45),_RGBY(0x46),_RGBY(0x47),
_RGBY(0x48),_RGBY(0x49),_RGBY(0x4A),_RGBY(0x4B),
_RGBY(0x4C),_RGBY(0x4D),_RGBY(0x4E),_RGBY(0x4F),
_RGBY(0x50),_RGBY(0x51),_RGBY(0x52),_RGBY(0x53),
_RGBY(0x54),_RGBY(0x55),_RGBY(0x56),_RGBY(0x57),
_RGBY(0x58),_RGBY(0x59),_RGBY(0x5A),_RGBY(0x5B),
_RGBY(0x5C),_RGBY(0x5D),_RGBY(0x5E),_RGBY(0x5F),
_RGBY(0x60),_RGBY(0x61),_RGBY(0x62),_RGBY(0x63),
_RGBY(0x64),_RGBY(0x65),_RGBY(0x66),_RGBY(0x67),
_RGBY(0x68),_RGBY(0x69),_RGBY(0x6A),_RGBY(0x6B),
_RGBY(0x6C),_RGBY(0x6D),_RGBY(0x6E),_RGBY(0x6F),
_RGBY(0x70),_RGBY(0x71),_RGBY(0x72),_RGBY(0x73),
_RGBY(0x74),_RGBY(0x75),_RGBY(0x76),_RGBY(0x77),
_RGBY(0x78),_RGBY(0x79),_RGBY(0x7A),_RGBY(0x7B),
_RGBY(0x7C),_RGBY(0x7D),_RGBY(0x7E),_RGBY(0x7F),
_RGBY(0x80),_RGBY(0x81),_RGBY(0x82),_RGBY(0x83),
_RGBY(0x84),_RGBY(0x85),_RGBY(0x86),_RGBY(0x87),
_RGBY(0x88),_RGBY(0x89),_RGBY(0x8A),_RGBY(0x8B),
_RGBY(0x8C),_RGBY(0x8D),_RGBY(0x8E),_RGBY(0x8F),
_RGBY(0x90),_RGBY(0x91),_RGBY(0x92),_RGBY(0x93),
_RGBY(0x94),_RGBY(0x95),_RGBY(0x96),_RGBY(0x97),
_RGBY(0x98),_RGBY(0x99),_RGBY(0x9A),_RGBY(0x9B),
_RGBY(0x9C),_RGBY(0x9D),_RGBY(0x9E),_RGBY(0x9F),
_RGBY(0xA0),_RGBY(0xA1),_RGBY(0xA2),_RGBY(0xA3),
_RGBY(0xA4),_RGBY(0xA5),_RGBY(0xA6),_RGBY(0xA7),
_RGBY(0xA8),_RGBY(0xA9),_RGBY(0xAA),_RGBY(0xAB),
_RGBY(0xAC),_RGBY(0xAD),_RGBY(0xAE),_RGBY(0xAF),
_RGBY(0xB0),_RGBY(0xB1),_RGBY(0xB2),_RGBY(0xB3),
_RGBY(0xB4),_RGBY(0xB5),_RGBY(0xB6),_RGBY(0xB7),
_RGBY(0xB8),_RGBY(0xB9),_RGBY(0xBA),_RGBY(0xBB),
_RGBY(0xBC),_RGBY(0xBD),_RGBY(0xBE),_RGBY(0xBF),
_RGBY(0xC0),_RGBY(0xC1),_RGBY(0xC2),_RGBY(0xC3),
_RGBY(0xC4),_RGBY(0xC5),_RGBY(0xC6),_RGBY(0xC7),
_RGBY(0xC8),_RGBY(0xC9),_RGBY(0xCA),_RGBY(0xCB),
_RGBY(0xCC),_RGBY(0xCD),_RGBY(0xCE),_RGBY(0xCF),
_RGBY(0xD0),_RGBY(0xD1),_RGBY(0xD2),_RGBY(0xD3),
_RGBY(0xD4),_RGBY(0xD5),_RGBY(0xD6),_RGBY(0xD7),
_RGBY(0xD8),_RGBY(0xD9),_RGBY(0xDA),_RGBY(0xDB),
_RGBY(0xDC),_RGBY(0xDD),_RGBY(0xDE),_RGBY(0xDF),
_RGBY(0xE0),_RGBY(0xE1),_RGBY(0xE2),_RGBY(0xE3),
_RGBY(0xE4),_RGBY(0xE5),_RGBY(0xE6),_RGBY(0xE7),
_RGBY(0xE8),_RGBY(0xE9),_RGBY(0xEA),_RGBY(0xEB),
_RGBY(0xEB),_RGBY(0xEB),_RGBY(0xEB),_RGBY(0xEB),
_RGBY(0xEB),_RGBY(0xEB),_RGBY(0xEB),_RGBY(0xEB),
_RGBY(0xEB),_RGBY(0xEB),_RGBY(0xEB),_RGBY(0xEB),
_RGBY(0xEB),_RGBY(0xEB),_RGBY(0xEB),_RGBY(0xEB),
_RGBY(0xEB),_RGBY(0xEB),_RGBY(0xEB),_RGBY(0xEB),

_RGBU(0x10),_RGBU(0x10),_RGBU(0x10),_RGBU(0x10),
_RGBU(0x10),_RGBU(0x10),_RGBU(0x10),_RGBU(0x10),
_RGBU(0x10),_RGBU(0x10),_RGBU(0x10),_RGBU(0x10),
_RGBU(0x10),_RGBU(0x10),_RGBU(0x10),_RGBU(0x10),
_RGBU(0x10),_RGBU(0x11),_RGBU(0x12),_RGBU(0x13),
_RGBU(0x14),_RGBU(0x15),_RGBU(0x16),_RGBU(0x17),
_RGBU(0x18),_RGBU(0x19),_RGBU(0x1A),_RGBU(0x1B),
_RGBU(0x1C),_RGBU(0x1D),_RGBU(0x1E),_RGBU(0x1F),
_RGBU(0x20),_RGBU(0x21),_RGBU(0x22),_RGBU(0x23),
_RGBU(0x24),_RGBU(0x25),_RGBU(0x26),_RGBU(0x27),
_RGBU(0x28),_RGBU(0x29),_RGBU(0x2A),_RGBU(0x2B),
_RGBU(0x2C),_RGBU(0x2D),_RGBU(0x2E),_RGBU(0x2F),
_RGBU(0x30),_RGBU(0x31),_RGBU(0x32),_RGBU(0x33),
_RGBU(0x34),_RGBU(0x35),_RGBU(0x36),_RGBU(0x37),
_RGBU(0x38),_RGBU(0x39),_RGBU(0x3A),_RGBU(0x3B),
_RGBU(0x3C),_RGBU(0x3D),_RGBU(0x3E),_RGBU(0x3F),
_RGBU(0x40),_RGBU(0x41),_RGBU(0x42),_RGBU(0x43),
_RGBU(0x44),_RGBU(0x45),_RGBU(0x46),_RGBU(0x47),
_RGBU(0x48),_RGBU(0x49),_RGBU(0x4A),_RGBU(0x4B),
_RGBU(0x4C),_RGBU(0x4D),_RGBU(0x4E),_RGBU(0x4F),
_RGBU(0x50),_RGBU(0x51),_RGBU(0x52),_RGBU(0x53),
_RGBU(0x54),_RGBU(0x55),_RGBU(0x56),_RGBU(0x57),
_RGBU(0x58),_RGBU(0x59),_RGBU(0x5A),_RGBU(0x5B),
_RGBU(0x5C),_RGBU(0x5D),_RGBU(0x5E),_RGBU(0x5F),
_RGBU(0x60),_RGBU(0x61),_RGBU(0x62),_RGBU(0x63),
_RGBU(0x64),_RGBU(0x65),_RGBU(0x66),_RGBU(0x67),
_RGBU(0x68),_RGBU(0x69),_RGBU(0x6A),_RGBU(0x6B),
_RGBU(0x6C),_RGBU(0x6D),_RGBU(0x6E),_RGBU(0x6F),
_RGBU(0x70),_RGBU(0x71),_RGBU(0x72),_RGBU(0x73),
_RGBU(0x74),_RGBU(0x75),_RGBU(0x76),_RGBU(0x77),
_RGBU(0x78),_RGBU(0x79),_RGBU(0x7A),_RGBU(0x7B),
_RGBU(0x7C),_RGBU(0x7D),_RGBU(0x7E),_RGBU(0x7F),
_RGBU(0x80),_RGBU(0x81),_RGBU(0x82),_RGBU(0x83),
_RGBU(0x84),_RGBU(0x85),_RGBU(0x86),_RGBU(0x87),
_RGBU(0x88),_RGBU(0x89),_RGBU(0x8A),_RGBU(0x8B),
_RGBU(0x8C),_RGBU(0x8D),_RGBU(0x8E),_RGBU(0x8F),
_RGBU(0x90),_RGBU(0x91),_RGBU(0x92),_RGBU(0x93),
_RGBU(0x94),_RGBU(0x95),_RGBU(0x96),_RGBU(0x97),
_RGBU(0x98),_RGBU(0x99),_RGBU(0x9A),_RGBU(0x9B),
_RGBU(0x9C),_RGBU(0x9D),_RGBU(0x9E),_RGBU(0x9F),
_RGBU(0xA0),_RGBU(0xA1),_RGBU(0xA2),_RGBU(0xA3),
_RGBU(0xA4),_RGBU(0xA5),_RGBU(0xA6),_RGBU(0xA7),
_RGBU(0xA8),_RGBU(0xA9),_RGBU(0xAA),_RGBU(0xAB),
_RGBU(0xAC),_RGBU(0xAD),_RGBU(0xAE),_RGBU(0xAF),
_RGBU(0xB0),_RGBU(0xB1),_RGBU(0xB2),_RGBU(0xB3),
_RGBU(0xB4),_RGBU(0xB5),_RGBU(0xB6),_RGBU(0xB7),
_RGBU(0xB8),_RGBU(0xB9),_RGBU(0xBA),_RGBU(0xBB),
_RGBU(0xBC),_RGBU(0xBD),_RGBU(0xBE),_RGBU(0xBF),
_RGBU(0xC0),_RGBU(0xC1),_RGBU(0xC2),_RGBU(0xC3),
_RGBU(0xC4),_RGBU(0xC5),_RGBU(0xC6),_RGBU(0xC7),
_RGBU(0xC8),_RGBU(0xC9),_RGBU(0xCA),_RGBU(0xCB),
_RGBU(0xCC),_RGBU(0xCD),_RGBU(0xCE),_RGBU(0xCF),
_RGBU(0xD0),_RGBU(0xD1),_RGBU(0xD2),_RGBU(0xD3),
_RGBU(0xD4),_RGBU(0xD5),_RGBU(0xD6),_RGBU(0xD7),
_RGBU(0xD8),_RGBU(0xD9),_RGBU(0xDA),_RGBU(0xDB),
_RGBU(0xDC),_RGBU(0xDD),_RGBU(0xDE),_RGBU(0xDF),
_RGBU(0xE0),_RGBU(0xE1),_RGBU(0xE2),_RGBU(0xE3),
_RGBU(0xE4),_RGBU(0xE5),_RGBU(0xE6),_RGBU(0xE7),
_RGBU(0xE8),_RGBU(0xE9),_RGBU(0xEA),_RGBU(0xEB),
_RGBU(0xEC),_RGBU(0xED),_RGBU(0xEE),_RGBU(0xEF),
_RGBU(0xF0),_RGBU(0xF0),_RGBU(0xF0),_RGBU(0xF0),
_RGBU(0xF0),_RGBU(0xF0),_RGBU(0xF0),_RGBU(0xF0),
_RGBU(0xF0),_RGBU(0xF0),_RGBU(0xF0),_RGBU(0xF0),
_RGBU(0xF0),_RGBU(0xF0),_RGBU(0xF0),_RGBU(0xF0),


_RGBV(0x10),_RGBV(0x10),_RGBV(0x10),_RGBV(0x10),
_RGBV(0x10),_RGBV(0x10),_RGBV(0x10),_RGBV(0x10),
_RGBV(0x10),_RGBV(0x10),_RGBV(0x10),_RGBV(0x10),
_RGBV(0x10),_RGBV(0x10),_RGBV(0x10),_RGBV(0x10),
_RGBV(0x10),_RGBV(0x11),_RGBV(0x12),_RGBV(0x13),
_RGBV(0x14),_RGBV(0x15),_RGBV(0x16),_RGBV(0x17),
_RGBV(0x18),_RGBV(0x19),_RGBV(0x1A),_RGBV(0x1B),
_RGBV(0x1C),_RGBV(0x1D),_RGBV(0x1E),_RGBV(0x1F),
_RGBV(0x20),_RGBV(0x21),_RGBV(0x22),_RGBV(0x23),
_RGBV(0x24),_RGBV(0x25),_RGBV(0x26),_RGBV(0x27),
_RGBV(0x28),_RGBV(0x29),_RGBV(0x2A),_RGBV(0x2B),
_RGBV(0x2C),_RGBV(0x2D),_RGBV(0x2E),_RGBV(0x2F),
_RGBV(0x30),_RGBV(0x31),_RGBV(0x32),_RGBV(0x33),
_RGBV(0x34),_RGBV(0x35),_RGBV(0x36),_RGBV(0x37),
_RGBV(0x38),_RGBV(0x39),_RGBV(0x3A),_RGBV(0x3B),
_RGBV(0x3C),_RGBV(0x3D),_RGBV(0x3E),_RGBV(0x3F),
_RGBV(0x40),_RGBV(0x41),_RGBV(0x42),_RGBV(0x43),
_RGBV(0x44),_RGBV(0x45),_RGBV(0x46),_RGBV(0x47),
_RGBV(0x48),_RGBV(0x49),_RGBV(0x4A),_RGBV(0x4B),
_RGBV(0x4C),_RGBV(0x4D),_RGBV(0x4E),_RGBV(0x4F),
_RGBV(0x50),_RGBV(0x51),_RGBV(0x52),_RGBV(0x53),
_RGBV(0x54),_RGBV(0x55),_RGBV(0x56),_RGBV(0x57),
_RGBV(0x58),_RGBV(0x59),_RGBV(0x5A),_RGBV(0x5B),
_RGBV(0x5C),_RGBV(0x5D),_RGBV(0x5E),_RGBV(0x5F),
_RGBV(0x60),_RGBV(0x61),_RGBV(0x62),_RGBV(0x63),
_RGBV(0x64),_RGBV(0x65),_RGBV(0x66),_RGBV(0x67),
_RGBV(0x68),_RGBV(0x69),_RGBV(0x6A),_RGBV(0x6B),
_RGBV(0x6C),_RGBV(0x6D),_RGBV(0x6E),_RGBV(0x6F),
_RGBV(0x70),_RGBV(0x71),_RGBV(0x72),_RGBV(0x73),
_RGBV(0x74),_RGBV(0x75),_RGBV(0x76),_RGBV(0x77),
_RGBV(0x78),_RGBV(0x79),_RGBV(0x7A),_RGBV(0x7B),
_RGBV(0x7C),_RGBV(0x7D),_RGBV(0x7E),_RGBV(0x7F),
_RGBV(0x80),_RGBV(0x81),_RGBV(0x82),_RGBV(0x83),
_RGBV(0x84),_RGBV(0x85),_RGBV(0x86),_RGBV(0x87),
_RGBV(0x88),_RGBV(0x89),_RGBV(0x8A),_RGBV(0x8B),
_RGBV(0x8C),_RGBV(0x8D),_RGBV(0x8E),_RGBV(0x8F),
_RGBV(0x90),_RGBV(0x91),_RGBV(0x92),_RGBV(0x93),
_RGBV(0x94),_RGBV(0x95),_RGBV(0x96),_RGBV(0x97),
_RGBV(0x98),_RGBV(0x99),_RGBV(0x9A),_RGBV(0x9B),
_RGBV(0x9C),_RGBV(0x9D),_RGBV(0x9E),_RGBV(0x9F),
_RGBV(0xA0),_RGBV(0xA1),_RGBV(0xA2),_RGBV(0xA3),
_RGBV(0xA4),_RGBV(0xA5),_RGBV(0xA6),_RGBV(0xA7),
_RGBV(0xA8),_RGBV(0xA9),_RGBV(0xAA),_RGBV(0xAB),
_RGBV(0xAC),_RGBV(0xAD),_RGBV(0xAE),_RGBV(0xAF),
_RGBV(0xB0),_RGBV(0xB1),_RGBV(0xB2),_RGBV(0xB3),
_RGBV(0xB4),_RGBV(0xB5),_RGBV(0xB6),_RGBV(0xB7),
_RGBV(0xB8),_RGBV(0xB9),_RGBV(0xBA),_RGBV(0xBB),
_RGBV(0xBC),_RGBV(0xBD),_RGBV(0xBE),_RGBV(0xBF),
_RGBV(0xC0),_RGBV(0xC1),_RGBV(0xC2),_RGBV(0xC3),
_RGBV(0xC4),_RGBV(0xC5),_RGBV(0xC6),_RGBV(0xC7),
_RGBV(0xC8),_RGBV(0xC9),_RGBV(0xCA),_RGBV(0xCB),
_RGBV(0xCC),_RGBV(0xCD),_RGBV(0xCE),_RGBV(0xCF),
_RGBV(0xD0),_RGBV(0xD1),_RGBV(0xD2),_RGBV(0xD3),
_RGBV(0xD4),_RGBV(0xD5),_RGBV(0xD6),_RGBV(0xD7),
_RGBV(0xD8),_RGBV(0xD9),_RGBV(0xDA),_RGBV(0xDB),
_RGBV(0xDC),_RGBV(0xDD),_RGBV(0xDE),_RGBV(0xDF),
_RGBV(0xE0),_RGBV(0xE1),_RGBV(0xE2),_RGBV(0xE3),
_RGBV(0xE4),_RGBV(0xE5),_RGBV(0xE6),_RGBV(0xE7),
_RGBV(0xE8),_RGBV(0xE9),_RGBV(0xEA),_RGBV(0xEB),
_RGBV(0xEC),_RGBV(0xED),_RGBV(0xEE),_RGBV(0xEF),
_RGBV(0xF0),_RGBV(0xF0),_RGBV(0xF0),_RGBV(0xF0),
_RGBV(0xF0),_RGBV(0xF0),_RGBV(0xF0),_RGBV(0xF0),
_RGBV(0xF0),_RGBV(0xF0),_RGBV(0xF0),_RGBV(0xF0),
_RGBV(0xF0),_RGBV(0xF0),_RGBV(0xF0),_RGBV(0xF0),
};
