/* FFmpeg project
* libavcodec (h264.c)
* H.26L/H.264/AVC/JVT/14496-10/... encoder/decoder
* Copyright (c) 2003 Michael Niedermayer <michaelni@gmx.at>
*
* This file has been modified for opensvcdecoder.


*****************************************************************************
*
*  Open SVC Decoder developped in IETR image lab
*
*
*
*              Mdric BLESTEL <mblestel@insa-rennes.Fr>
*              Mickael RAULET <mraulet@insa-rennes.Fr>
*              http://www.ietr.org/
*
*
*
*
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*
*
* $Id$
*
**************************************************************************/

#include "data.h"
#include "clip.h"
#include "refill.h"
#include "init_data.h"
#include "write_back.h"
#include "cabac_table.h"
#include "mb_pred_main.h"
#include "neighbourhood.h"
#include "motion_vector.h"
#include "BitstreamSkip.h"
#include "BitstreamSkipB.h"
#include "slice_data_cabac.h"




unsigned char cabac_state[467];
int cabac_context_init_I[467][2] =
{
	/* 0 - 10 */
	{ 20, -15 }, {  2, 54 },  {  3,  74 }, { 20, -15 },
	{  2,  54 }, {  3, 74 },  { -28,127 }, { -23, 104 },
	{ -6,  53 }, { -1, 54 },  {  7,  51 },

	/* 11 - 23 unsused for I */
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },
	{ 0, 0 },

	/* 24- 39 */
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },

	/* 40 - 53 */
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },
	{ 0, 0 },    { 0, 0 },

	/* 54 - 59 */
	{ 0, 0 },    { 0, 0 },    { 0, 0 },      { 0, 0 },
	{ 0, 0 },    { 0, 0 },

	/* 60 - 69 */
	{ 0, 41 },   { 0, 63 },   { 0, 63 },     { 0, 63 },
	{ -9, 83 },  { 4, 86 },   { 0, 97 },     { -7, 72 },
	{ 13, 41 },  { 3, 62 },

	/* 70 -> 87 */
	{ 0, 11 },   { 1, 55 },   { 0, 69 },     { -17, 127 },
	{ -13, 102 },{ 0, 82 },   { -7, 74 },    { -21, 107 },
	{ -27, 127 },{ -31, 127 },{ -24, 127 },  { -18, 95 },
	{ -27, 127 },{ -21, 114 },{ -30, 127 },  { -17, 123 },
	{ -12, 115 },{ -16, 122 },

	/* 88 -> 104 */
	{ -11, 115 },{ -12, 63 }, { -2, 68 },    { -15, 84 },
	{ -13, 104 },{ -3, 70 },  { -8, 93 },    { -10, 90 },
	{ -30, 127 },{ -1, 74 },  { -6, 97 },    { -7, 91 },
	{ -20, 127 },{ -4, 56 },  { -5, 82 },    { -7, 76 },
	{ -22, 125 },

	/* 105 -> 135 */
	{ -7, 93 },  { -11, 87 }, { -3, 77 },    { -5, 71 },
	{ -4, 63 },  { -4, 68 },  { -12, 84 },   { -7, 62 },
	{ -7, 65 },  { 8, 61 },   { 5, 56 },     { -2, 66 },
	{ 1, 64 },   { 0, 61 },   { -2, 78 },    { 1, 50 },
	{ 7, 52 },   { 10, 35 },  { 0, 44 },     { 11, 38 },
	{ 1, 45 },   { 0, 46 },   { 5, 44 },     { 31, 17 },
	{ 1, 51 },   { 7, 50 },   { 28, 19 },    { 16, 33 },
	{ 14, 62 },  { -13, 108 },{ -15, 100 },

	/* 136 -> 165 */
	{ -13, 101 },{ -13, 91 }, { -12, 94 },   { -10, 88 },
	{ -16, 84 }, { -10, 86 }, { -7, 83 },    { -13, 87 },
	{ -19, 94 }, { 1, 70 },   { 0, 72 },     { -5, 74 },
	{ 18, 59 },  { -8, 102 }, { -15, 100 },  { 0, 95 },
	{ -4, 75 },  { 2, 72 },   { -11, 75 },   { -3, 71 },
	{ 15, 46 },  { -13, 69 }, { 0, 62 },     { 0, 65 },
	{ 21, 37 },  { -15, 72 }, { 9, 57 },     { 16, 54 },
	{ 0, 62 },   { 12, 72 },

	/* 166 -> 196 */
	{ 24, 0 },   { 15, 9 },   { 8, 25 },     { 13, 18 },
	{ 15, 9 },   { 13, 19 },  { 10, 37 },    { 12, 18 },
	{ 6, 29 },   { 20, 33 },  { 15, 30 },    { 4, 45 },
	{ 1, 58 },   { 0, 62 },   { 7, 61 },     { 12, 38 },
	{ 11, 45 },  { 15, 39 },  { 11, 42 },    { 13, 44 },
	{ 16, 45 },  { 12, 41 },  { 10, 49 },    { 30, 34 },
	{ 18, 42 },  { 10, 55 },  { 17, 51 },    { 17, 46 },
	{ 0, 89 },   { 26, -19 }, { 22, -17 },

	/* 197 -> 226 */
	{ 26, -17 }, { 30, -25 }, { 28, -20 },   { 33, -23 },
	{ 37, -27 }, { 33, -23 }, { 40, -28 },   { 38, -17 },
	{ 33, -11 }, { 40, -15 }, { 41, -6 },    { 38, 1 },
	{ 41, 17 },  { 30, -6 },  { 27, 3 },     { 26, 22 },
	{ 37, -16 }, { 35, -4 },  { 38, -8 },    { 38, -3 },
	{ 37, 3 },   { 38, 5 },   { 42, 0 },     { 35, 16 },
	{ 39, 22 },  { 14, 48 },  { 27, 37 },    { 21, 60 },
	{ 12, 68 },  { 2, 97 },

	/* 227 -> 251 */
	{ -3, 71 },  { -6, 42 },  { -5, 50 },    { -3, 54 },
	{ -2, 62 },  { 0, 58 },   { 1, 63 },     { -2, 72 },
	{ -1, 74 },  { -9, 91 },  { -5, 67 },    { -5, 27 },
	{ -3, 39 },  { -2, 44 },  { 0, 46 },     { -16, 64 },
	{ -8, 68 },  { -10, 78 }, { -6, 77 },    { -10, 86 },
	{ -12, 92 }, { -15, 55 }, { -10, 60 },   { -6, 62 },
	{ -4, 65 },

	/* 252 -> 275 */
	{ -12, 73 }, { -8, 76 },  { -7, 80 },    { -9, 88 },
	{ -17, 110 },{ -11, 97 }, { -20, 84 },   { -11, 79 },
	{ -6, 73 },  { -4, 74 },  { -13, 86 },   { -13, 96 },
	{ -11, 97 }, { -19, 117 },{ -8, 78 },    { -5, 33 },
	{ -4, 48 },  { -2, 53 },  { -3, 62 },    { -13, 71 },
	{ -10, 79 }, { -12, 86 }, { -13, 90 },   { -14, 97 },

	/* 276 a bit special (not used, bypass is used instead) */
	{ 0, 0 },

	/* 277 -> 307 */
	{ -6, 93 },  { -6, 84 },  { -8, 79 },    { 0, 66 },
	{ -1, 71 },  { 0, 62 },   { -2, 60 },    { -2, 59 },
	{ -5, 75 },  { -3, 62 },  { -4, 58 },    { -9, 66 },
	{ -1, 79 },  { 0, 71 },   { 3, 68 },     { 10, 44 },
	{ -7, 62 },  { 15, 36 },  { 14, 40 },    { 16, 27 },
	{ 12, 29 },  { 1, 44 },   { 20, 36 },    { 18, 32 },
	{ 5, 42 },   { 1, 48 },   { 10, 62 },    { 17, 46 },
	{ 9, 64 },   { -12, 104 },{ -11, 97 },

	/* 308 -> 337 */
	{ -16, 96 }, { -7, 88 },  { -8, 85 },    { -7, 85 },
	{ -9, 85 },  { -13, 88 }, { 4, 66 },     { -3, 77 },
	{ -3, 76 },  { -6, 76 },  { 10, 58 },    { -1, 76 },
	{ -1, 83 },  { -7, 99 },  { -14, 95 },   { 2, 95 },
	{ 0, 76 },   { -5, 74 },  { 0, 70 },     { -11, 75 },
	{ 1, 68 },   { 0, 65 },   { -14, 73 },   { 3, 62 },
	{ 4, 62 },   { -1, 68 },  { -13, 75 },   { 11, 55 },
	{ 5, 64 },   { 12, 70 },

	/* 338 -> 368 */
	{ 15, 6 },   { 6, 19 },   { 7, 16 },     { 12, 14 },
	{ 18, 13 },  { 13, 11 },  { 13, 15 },    { 15, 16 },
	{ 12, 23 },  { 13, 23 },  { 15, 20 },    { 14, 26 },
	{ 14, 44 },  { 17, 40 },  { 17, 47 },    { 24, 17 },
	{ 21, 21 },  { 25, 22 },  { 31, 27 },    { 22, 29 },
	{ 19, 35 },  { 14, 50 },  { 10, 57 },    { 7, 63 },
	{ -2, 77 },  { -4, 82 },  { -3, 94 },    { 9, 69 },
	{ -12, 109 },{ 36, -35 }, { 36, -34 },

	/* 369 -> 398 */
	{ 32, -26 }, { 37, -30 }, { 44, -32 },   { 34, -18 },
	{ 34, -15 }, { 40, -15 }, { 33, -7 },    { 35, -5 },
	{ 33, 0 },   { 38, 2 },   { 33, 13 },    { 23, 35 },
	{ 13, 58 },  { 29, -3 },  { 26, 0 },     { 22, 30 },
	{ 31, -7 },  { 35, -15 }, { 34, -3 },    { 34, 3 },
	{ 36, -1 },  { 34, 5 },   { 32, 11 },    { 35, 5 },
	{ 34, 12 },  { 39, 11 },  { 30, 29 },    { 34, 26 },
	{ 29, 39 },  { 19, 66 },

	/* 399 -> 435 */
	{  31,  21 }, {  31,  31 }, {  25,  50 },
	{ -17, 120 }, { -20, 112 }, { -18, 114 }, { -11,  85 },
	{ -15,  92 }, { -14,  89 }, { -26,  71 }, { -15,  81 },
	{ -14,  80 }, {   0,  68 }, { -14,  70 }, { -24,  56 },
	{ -23,  68 }, { -24,  50 }, { -11,  74 }, {  23, -13 },
	{  26, -13 }, {  40, -15 }, {  49, -14 }, {  44,   3 },
	{  45,   6 }, {  44,  34 }, {  33,  54 }, {  19,  82 },
	{  -3,  75 }, {  -1,  23 }, {   1,  34 }, {   1,  43 },
	{   0,  54 }, {  -2,  55 }, {   0,  61 }, {   1,  64 },
	{   0,  68 }, {  -9,  92 },

	/* 436 -> 459 */
	{ -14, 106 }, { -13,  97 }, { -15,  90 }, { -12,  90 },
	{ -18,  88 }, { -10,  73 }, {  -9,  79 }, { -14,  86 },
	{ -10,  73 }, { -10,  70 }, { -10,  69 }, {  -5,  66 },
	{  -9,  64 }, {  -5,  58 }, {   2,  59 }, {  21, -10 },
	{  24, -11 }, {  28,  -8 }, {  28,  -1 }, {  29,   3 },
	{  29,   9 }, {  35,  20 }, {  29,  36 }, {  14,  67 },


	//Svc Stuff
	//Be carefull, should be a ctxIdx == 1024 to 1029
	/* 460 -> 466 */
	{ -14, 138 }, { -22, 140 }, { -11,  99},
	{  -6,  67 }, {  -6,  67 }, { -23, 104 }, { -35, 106}
};

int cabac_context_init_PB[3][467][2] =
{
	/* i_cabac_init_idc == 0 */
	{
		/* 0 - 10 */
		{  20, -15 }, {   2,  54 }, {   3,  74 }, {  20, -15 },
		{   2,  54 }, {   3,  74 }, { -28, 127 }, { -23, 104 },
		{  -6,  53 }, {  -1,  54 }, {   7,  51 },

		/* 11 - 23 */
		{  23,  33 }, {  23,   2 }, {  21,   0 }, {   1,   9 },
		{   0,  49 }, { -37, 118 }, {   5,  57 }, { -13,  78 },
		{ -11,  65 }, {   1,  62 }, {  12,  49 }, {  -4,  73 },
		{  17,  50 },

		/* 24 - 39 */
		{  18,  64 }, {   9,  43 }, {  29,   0 }, {  26,  67 },
		{  16,  90 }, {   9, 104 }, { -46, 127 }, { -20, 104 },
		{   1,  67 }, { -13,  78 }, { -11,  65 }, {   1,  62 },
		{  -6,  86 }, { -17,  95 }, {  -6,  61 }, {   9,  45 },

		/* 40 - 53 */
		{  -3,  69 }, {  -6,  81 }, { -11,  96 }, {   6,  55 },
		{   7,  67 }, {  -5,  86 }, {   2,  88 }, {   0,  58 },
		{  -3,  76 }, { -10,  94 }, {   5,  54 }, {   4,  69 },
		{  -3,  81 }, {   0,  88 },

		/* 54 - 59 */
		{  -7,  67 }, {  -5,  74 }, {  -4,  74 }, {  -5,  80 },
		{  -7,  72 }, {   1,  58 },

		/* 60 - 69 */
		{   0,  41 }, {   0,  63 }, {   0,  63 }, { 0, 63 },
		{  -9,  83 }, {   4,  86 }, {   0,  97 }, { -7, 72 },
		{  13,  41 }, {   3,  62 },

		/* 70 - 87 */
		{   0,  45 }, {  -4,  78 }, {  -3,  96 }, { -27,  126 },
		{ -28,  98 }, { -25, 101 }, { -23,  67 }, { -28,  82 },
		{ -20,  94 }, { -16,  83 }, { -22, 110 }, { -21,  91 },
		{ -18, 102 }, { -13,  93 }, { -29, 127 }, {  -7,  92 },
		{  -5,  89 }, {  -7,  96 }, { -13, 108 }, {  -3,  46 },
		{  -1,  65 }, {  -1,  57 }, {  -9,  93 }, {  -3,  74 },
		{  -9,  92 }, {  -8,  87 }, { -23, 126 }, {   5,  54 },
		{   6,  60 }, {   6,  59 }, {   6,  69 }, {  -1,  48 },
		{   0,  68 }, {  -4,  69 }, {  -8,  88 },

		/* 105 -> 165 */
		{  -2,  85 }, {  -6,  78 }, {  -1,  75 }, {  -7,  77 },
		{   2,  54 }, {   5,  50 }, {  -3,  68 }, {   1,  50 },
		{   6,  42 }, {  -4,  81 }, {   1,  63 }, {  -4,  70 },
		{   0,  67 }, {   2,  57 }, {  -2,  76 }, {  11,  35 },
		{   4,  64 }, {   1,  61 }, {  11,  35 }, {  18,  25 },
		{  12,  24 }, {  13,  29 }, {  13,  36 }, { -10,  93 },
		{  -7,  73 }, {  -2,  73 }, {  13,  46 }, {   9,  49 },
		{  -7, 100 }, {   9,  53 }, {   2,  53 }, {   5,  53 },
		{  -2,  61 }, {   0,  56 }, {   0,  56 }, { -13,  63 },
		{  -5,  60 }, {  -1,  62 }, {   4,  57 }, {  -6,  69 },
		{   4,  57 }, {  14,  39 }, {   4,  51 }, {  13,  68 },
		{   3,  64 }, {   1,  61 }, {   9,  63 }, {   7,  50 },
		{  16,  39 }, {   5,  44 }, {   4,  52 }, {  11,  48 },
		{  -5,  60 }, {  -1,  59 }, {   0,  59 }, {  22,  33 },
		{   5,  44 }, {  14,  43 }, {  -1,  78 }, {   0,  60 },
		{   9,  69 },

		/* 166 - 226 */
		{  11,  28 }, {   2,  40 }, {   3,  44 }, {   0,  49 },
		{   0,  46 }, {   2,  44 }, {   2,  51 }, {   0,  47 },
		{   4,  39 }, {   2,  62 }, {   6,  46 }, {   0,  54 },
		{   3,  54 }, {   2,  58 }, {   4,  63 }, {   6,  51 },
		{   6,  57 }, {   7,  53 }, {   6,  52 }, {   6,  55 },
		{  11,  45 }, {  14,  36 }, {   8,  53 }, {  -1,  82 },
		{   7,  55 }, {  -3,  78 }, {  15,  46 }, {  22,  31 },
		{  -1,  84 }, {  25,   7 }, {  30,  -7 }, {  28,   3 },
		{  28,   4 }, {  32,   0 }, {  34,  -1 }, {  30,   6 },
		{  30,   6 }, {  32,   9 }, {  31,  19 }, {  26,  27 },
		{  26,  30 }, {  37,  20 }, {  28,  34 }, {  17,  70 },
		{   1,  67 }, {   5,  59 }, {   9,  67 }, {  16,  30 },
		{  18,  32 }, {  18,  35 }, {  22,  29 }, {  24,  31 },
		{  23,  38 }, {  18,  43 }, {  20,  41 }, {  11,  63 },
		{   9,  59 }, {   9,  64 }, {  -1,  94 }, {  -2,  89 },
		{  -9, 108 },

		/* 227 - 275 */
		{  -6,  76 }, {  -2,  44 }, {   0,  45 }, {   0,  52 },
		{  -3,  64 }, {  -2,  59 }, {  -4,  70 }, {  -4,  75 },
		{  -8,  82 }, { -17, 102 }, {  -9,  77 }, {   3,  24 },
		{   0,  42 }, {   0,  48 }, {   0,  55 }, {  -6,  59 },
		{  -7,  71 }, { -12,  83 }, { -11,  87 }, { -30, 119 },
		{   1,  58 }, {  -3,  29 }, {  -1,  36 }, {   1,  38 },
		{   2,  43 }, {  -6,  55 }, {   0,  58 }, {   0,  64 },
		{  -3,  74 }, { -10,  90 }, {   0,  70 }, {  -4,  29 },
		{   5,  31 }, {   7,  42 }, {   1,  59 }, {  -2,  58 },
		{  -3,  72 }, {  -3,  81 }, { -11,  97 }, {   0,  58 },
		{   8,   5 }, {  10,  14 }, {  14,  18 }, {  13,  27 },
		{   2,  40 }, {   0,  58 }, {  -3,  70 }, {  -6,  79 },
		{  -8,  85 },

		/* 276 a bit special (not used, bypass is used instead) */
		{ 0, 0 },

		/* 277 - 337 */
		{ -13, 106 }, { -16, 106 }, { -10,  87 }, { -21, 114 },
		{ -18, 110 }, { -14,  98 }, { -22, 110 }, { -21, 106 },
		{ -18, 103 }, { -21, 107 }, { -23, 108 }, { -26, 112 },
		{ -10,  96 }, { -12,  95 }, {  -5,  91 }, {  -9,  93 },
		{ -22,  94 }, {  -5,  86 }, {   9,  67 }, {  -4,  80 },
		{ -10,  85 }, {  -1,  70 }, {   7,  60 }, {   9,  58 },
		{   5,  61 }, {  12,  50 }, {  15,  50 }, {  18,  49 },
		{  17,  54 }, {  10,  41 }, {   7,  46 }, {  -1,  51 },
		{   7,  49 }, {   8,  52 }, {   9,  41 }, {   6,  47 },
		{   2,  55 }, {  13,  41 }, {  10,  44 }, {   6,  50 },
		{   5,  53 }, {  13,  49 }, {   4,  63 }, {   6,  64 },
		{  -2,  69 }, {  -2,  59 }, {   6,  70 }, {  10,  44 },
		{   9,  31 }, {  12,  43 }, {   3,  53 }, {  14,  34 },
		{  10,  38 }, {  -3,  52 }, {  13,  40 }, {  17,  32 },
		{   7,  44 }, {   7,  38 }, {  13,  50 }, {  10,  57 },
		{  26,  43 },

		/* 338 - 398 */
		{  14,  11 }, {  11,  14 }, {   9,  11 }, {  18,  11 },
		{  21,   9 }, {  23,  -2 }, {  32, -15 }, {  32, -15 },
		{  34, -21 }, {  39, -23 }, {  42, -33 }, {  41, -31 },
		{  46, -28 }, {  38, -12 }, {  21,  29 }, {  45, -24 },
		{  53, -45 }, {  48, -26 }, {  65, -43 }, {  43, -19 },
		{  39, -10 }, {  30,   9 }, {  18,  26 }, {  20,  27 },
		{   0,  57 }, { -14,  82 }, {  -5,  75 }, { -19,  97 },
		{ -35, 125 }, {  27,   0 }, {  28,   0 }, {  31,  -4 },
		{  27,   6 }, {  34,   8 }, {  30,  10 }, {  24,  22 },
		{  33,  19 }, {  22,  32 }, {  26,  31 }, {  21,  41 },
		{  26,  44 }, {  23,  47 }, {  16,  65 }, {  14,  71 },
		{   8,  60 }, {   6,  63 }, {  17,  65 }, {  21,  24 },
		{  23,  20 }, {  26,  23 }, {  27,  32 }, {  28,  23 },
		{  28,  24 }, {  23,  40 }, {  24,  32 }, {  28,  29 },
		{  23,  42 }, {  19,  57 }, {  22,  53 }, {  22,  61 },
		{  11,  86 },

		/* 399 - 435 */
		{  12,  40 }, {  11,  51 }, {  14,  59 },
		{  -4,  79 }, {  -7,  71 }, {  -5,  69 }, {  -9,  70 },
		{  -8,  66 }, { -10,  68 }, { -19,  73 }, { -12,  69 },
		{ -16,  70 }, { -15,  67 }, { -20,  62 }, { -19,  70 },
		{ -16,  66 }, { -22,  65 }, { -20,  63 }, {   9,  -2 },
		{  26,  -9 }, {  33,  -9 }, {  39,  -7 }, {  41,  -2 },
		{  45,   3 }, {  49,   9 }, {  45,  27 }, {  36,  59 },
		{  -6,  66 }, {  -7,  35 }, {  -7,  42 }, {  -8,  45 },
		{  -5,  48 }, { -12,  56 }, {  -6,  60 }, {  -5,  62 },
		{  -8,  66 }, {  -8,  76 },

		/* 436 - 459 */
		{  -5,  85 }, {  -6,  81 }, { -10,  77 }, {  -7,  81 },
		{ -17,  80 }, { -18,  73 }, {  -4,  74 }, { -10,  83 },
		{  -9,  71 }, {  -9,  67 }, {  -1,  61 }, {  -8,  66 },
		{ -14,  66 }, {   0,  59 }, {   2,  59 }, {  21, -13 },
		{  33, -14 }, {  39,  -7 }, {  46,  -2 }, {  51,   2 },
		{  60,   6 }, {  61,  17 }, {  55,  34 }, {  42,  62 },

		//Svc Stuff
		//Be carefull, should be a ctxIdx == 1024 to 1029
		/* 460 -> 467 */
		{  0,   75 }, {   2,  65 }, {   2,  59},
		{  -6,  67 }, {  -6,  67 }, { -23, 104 }, { -35, 106}
	},

		/* i_cabac_init_idc == 1 */
	{
		/* 0 - 10 */
		{  20, -15 }, {   2,  54 }, {   3,  74 }, {  20, -15 },
		{   2,  54 }, {   3,  74 }, { -28, 127 }, { -23, 104 },
		{  -6,  53 }, {  -1,  54 }, {   7,  51 },

		/* 11 - 23 */
		{  22,  25 }, {  34,   0 }, {  16,   0 }, {  -2,   9 },
		{   4,  41 }, { -29, 118 }, {   2,  65 }, {  -6,  71 },
		{ -13,  79 }, {   5,  52 }, {   9,  50 }, {  -3,  70 },
		{  10,  54 },

		/* 24 - 39 */
		{  26,  34 }, {  19,  22 }, {  40,   0 }, {  57,   2 },
		{  41,  36 }, {  26,  69 }, { -45, 127 }, { -15, 101 },
		{  -4,  76 }, {  -6,  71 }, { -13,  79 }, {   5,  52 },
		{   6,  69 }, { -13,  90 }, {   0,  52 }, {   8,  43 },

		/* 40 - 53 */
		{  -2,  69 },{  -5,  82 },{ -10,  96 },{   2,  59 },
		{   2,  75 },{  -3,  87 },{  -3,  100 },{   1,  56 },
		{  -3,  74 },{  -6,  85 },{   0,  59 },{  -3,  81 },
		{  -7,  86 },{  -5,  95 },

		/* 54 - 59 */
		{  -1,  66 },{  -1,  77 },{   1,  70 },{  -2,  86 },
		{  -5,  72 },{   0,  61 },

		/* 60 - 69 */
		{ 0, 41 },   { 0, 63 },   { 0, 63 },     { 0, 63 },
		{ -9, 83 },  { 4, 86 },   { 0, 97 },     { -7, 72 },
		{ 13, 41 },  { 3, 62 },

		/* 70 - 104 */
		{  13,  15 }, {   7,  51 }, {   2,  80 }, { -39, 127 },
		{ -18,  91 }, { -17,  96 }, { -26,  81 }, { -35,  98 },
		{ -24, 102 }, { -23,  97 }, { -27, 119 }, { -24,  99 },
		{ -21, 110 }, { -18, 102 }, { -36, 127 }, {   0,  80 },
		{  -5,  89 }, {  -7,  94 }, {  -4,  92 }, {   0,  39 },
		{   0,  65 }, { -15,  84 }, { -35, 127 }, {  -2,  73 },
		{ -12, 104 }, {  -9,  91 }, { -31, 127 }, {   3,  55 },
		{   7,  56 }, {   7,  55 }, {   8,  61 }, {  -3,  53 },
		{   0,  68 }, {  -7,  74 }, {  -9,  88 },

		/* 105 -> 165 */
		{ -13, 103 }, { -13,  91 }, {  -9,  89 }, { -14,  92 },
		{  -8,  76 }, { -12,  87 }, { -23, 110 }, { -24, 105 },
		{ -10,  78 }, { -20, 112 }, { -17,  99 }, { -78, 127 },
		{ -70, 127 }, { -50, 127 }, { -46, 127 }, {  -4,  66 },
		{  -5,  78 }, {  -4,  71 }, {  -8,  72 }, {   2,  59 },
		{  -1,  55 }, {  -7,  70 }, {  -6,  75 }, {  -8,  89 },
		{ -34, 119 }, {  -3,  75 }, {  32,  20 }, {  30,  22 },
		{ -44, 127 }, {   0,  54 }, {  -5,  61 }, {   0,  58 },
		{  -1,  60 }, {  -3,  61 }, {  -8,  67 }, { -25,  84 },
		{ -14,  74 }, {  -5,  65 }, {   5,  52 }, {   2,  57 },
		{   0,  61 }, {  -9,  69 }, { -11,  70 }, {  18,  55 },
		{  -4,  71 }, {   0,  58 }, {   7,  61 }, {   9,  41 },
		{  18,  25 }, {   9,  32 }, {   5,  43 }, {   9,  47 },
		{   0,  44 }, {   0,  51 }, {   2,  46 }, {  19,  38 },
		{  -4,  66 }, {  15,  38 }, {  12,  42 }, {   9,  34 },
		{   0,  89 },

		/* 166 - 226 */
		{   4,  45 }, {  10,  28 }, {  10,  31 }, {  33, -11 },
		{  52, -43 }, {  18,  15 }, {  28,   0 }, {  35, -22 },
		{  38, -25 }, {  34,   0 }, {  39, -18 }, {  32, -12 },
		{ 102, -94 }, {   0,   0 }, {  56, -15 }, {  33,  -4 },
		{  29,  10 }, {  37,  -5 }, {  51, -29 }, {  39,  -9 },
		{  52, -34 }, {  69, -58 }, {  67, -63 }, {  44,  -5 },
		{  32,   7 }, {  55, -29 }, {  32,   1 }, {   0,   0 },
		{  27,  36 }, {  33, -25 }, {  34, -30 }, {  36, -28 },
		{  38, -28 }, {  38, -27 }, {  34, -18 }, {  35, -16 },
		{  34, -14 }, {  32,  -8 }, {  37,  -6 }, {  35,   0 },
		{  30,  10 }, {  28,  18 }, {  26,  25 }, {  29,  41 },
		{   0,  75 }, {   2,  72 }, {   8,  77 }, {  14,  35 },
		{  18,  31 }, {  17,  35 }, {  21,  30 }, {  17,  45 },
		{  20,  42 }, {  18,  45 }, {  27,  26 }, {  16,  54 },
		{   7,  66 }, {  16,  56 }, {  11,  73 }, {  10,  67 },
		{ -10, 116 },

		/* 227 - 275 */
		{ -23, 112 }, { -15,  71 }, {  -7,  61 }, {   0,  53 },
		{  -5,  66 }, { -11,  77 }, {  -9,  80 }, {  -9,  84 },
		{ -10,  87 }, { -34, 127 }, { -21, 101 }, {  -3,  39 },
		{  -5,  53 }, {  -7,  61 }, { -11,  75 }, { -15,  77 },
		{ -17,  91 }, { -25, 107 }, { -25, 111 }, { -28, 122 },
		{ -11,  76 }, { -10,  44 }, { -10,  52 }, { -10,  57 },
		{  -9,  58 }, { -16,  72 }, {  -7,  69 }, {  -4,  69 },
		{  -5,  74 }, {  -9,  86 }, {   2,  66 }, {  -9,  34 },
		{   1,  32 }, {  11,  31 }, {   5,  52 }, {  -2,  55 },
		{  -2,  67 }, {   0,  73 }, {  -8,  89 }, {   3,  52 },
		{   7,   4 }, {  10,   8 }, {  17,   8 }, {  16,  19 },
		{   3,  37 }, {  -1,  61 }, {  -5,  73 }, {  -1,  70 },
		{  -4,  78 },

		/* 276 a bit special (not used, bypass is used instead) */
		{ 0, 0 },

		/* 277 - 337 */
		{ -21, 126 }, { -23, 124 }, { -20, 110 }, { -26, 126 },
		{ -25, 124 }, { -17, 105 }, { -27, 121 }, { -27, 117 },
		{ -17, 102 }, { -26, 117 }, { -27, 116 }, { -33, 122 },
		{ -10,  95 }, { -14, 100 }, {  -8,  95 }, { -17, 111 },
		{ -28, 114 }, {  -6,  89 }, {  -2,  80 }, {  -4,  82 },
		{  -9,  85 }, {  -8,  81 }, {  -1,  72 }, {   5,  64 },
		{   1,  67 }, {   9,  56 }, {   0,  69 }, {   1,  69 },
		{   7,  69 }, {  -7,  69 }, {  -6,  67 }, { -16,  77 },
		{  -2,  64 }, {   2,  61 }, {  -6,  67 }, {  -3,  64 },
		{   2,  57 }, {  -3,  65 }, {  -3,  66 }, {   0,  62 },
		{   9,  51 }, {  -1,  66 }, {  -2,  71 }, {  -2,  75 },
		{  -1,  70 }, {  -9,  72 }, {  14,  60 }, {  16,  37 },
		{   0,  47 }, {  18,  35 }, {  11,  37 }, {  12,  41 },
		{  10,  41 }, {   2,  48 }, {  12,  41 }, {  13,  41 },
		{   0,  59 }, {   3,  50 }, {  19,  40 }, {   3,  66 },
		{  18,  50 },

		/* 338 - 398 */
		{  19,  -6 }, {  18,  -6 }, {  14,   0 }, {  26, -12 },
		{  31, -16 }, {  33, -25 }, {  33, -22 }, {  37, -28 },
		{  39, -30 }, {  42, -30 }, {  47, -42 }, {  45, -36 },
		{  49, -34 }, {  41, -17 }, {  32,   9 }, {  69, -71 },
		{  63, -63 }, {  66, -64 }, {  77, -74 }, {  54, -39 },
		{  52, -35 }, {  41, -10 }, {  36,   0 }, {  40,  -1 },
		{  30,  14 }, {  28,  26 }, {  23,  37 }, {  12,  55 },
		{  11,  65 }, {  37, -33 }, {  39, -36 }, {  40, -37 },
		{  38, -30 }, {  46, -33 }, {  42, -30 }, {  40, -24 },
		{  49, -29 }, {  38, -12 }, {  40, -10 }, {  38,  -3 },
		{  46,  -5 }, {  31,  20 }, {  29,  30 }, {  25,  44 },
		{  12,  48 }, {  11,  49 }, {  26,  45 }, {  22,  22 },
		{  23,  22 }, {  27,  21 }, {  33,  20 }, {  26,  28 },
		{  30,  24 }, {  27,  34 }, {  18,  42 }, {  25,  39 },
		{  18,  50 }, {  12,  70 }, {  21,  54 }, {  14,  71 },
		{  11,  83 },

		/* 399 - 435 */
		{  25,  32 }, {  21,  49 }, {  21,  54 },
		{  -5,  85 }, {  -6,  81 }, { -10,  77 }, {  -7,  81 },
		{ -17,  80 }, { -18,  73 }, {  -4,  74 }, { -10,  83 },
		{  -9,  71 }, {  -9,  67 }, {  -1,  61 }, {  -8,  66 },
		{ -14,  66 }, {   0,  59 }, {   2,  59 }, {  17, -10 },
		{  32, -13 }, {  42,  -9 }, {  49,  -5 }, {  53,   0 },
		{  64,   3 }, {  68,  10 }, {  66,  27 }, {  47,  57 },
		{  -5,  71 }, {   0,  24 }, {  -1,  36 }, {  -2,  42 },
		{  -2,  52 }, {  -9,  57 }, {  -6,  63 }, {  -4,  65 },
		{  -4,  67 }, {  -7,  82 },

		/* 436 - 459 */
		{  -3,  81 }, {  -3,  76 }, {  -7,  72 }, {  -6,  78 },
		{ -12,  72 }, { -14,  68 }, {  -3,  70 }, {  -6,  76 },
		{  -5,  66 }, {  -5,  62 }, {   0,  57 }, {  -4,  61 },
		{  -9,  60 }, {   1,  54 }, {   2,  58 }, {  17, -10 },
		{  32, -13 }, {  42,  -9 }, {  49,  -5 }, {  53,   0 },
		{  64,   3 }, {  68,  10 }, {  66,  27 }, {  47,  57 },

		//Svc Stuff
		//Be carefull, should be a ctxIdx == 1024 to 1029
		/* 460 -> 466 */
		{  0,   75 }, {   2,  65 }, {   2,  59},
		{  -6,  67 }, {  -6,  67 }, { -23, 104 }, { -35, 106}
	},

		/* i_cabac_init_idc == 2 */
	{
		/* 0 - 10 */
		{  20, -15 }, {   2,  54 }, {   3,  74 }, {  20, -15 },
		{   2,  54 }, {   3,  74 }, { -28, 127 }, { -23, 104 },
		{  -6,  53 }, {  -1,  54 }, {   7,  51 },

		/* 11 - 23 */
		{  29,  16 }, {  25,   0 }, {  14,   0 }, { -10,  51 },
		{  -3,  62 }, { -27,  99 }, {  26,  16 }, {  -4,  85 },
		{ -24, 102 }, {   5,  57 }, {   6,  57 }, { -17,  73 },
		{  14,  57 },

		/* 24 - 39 */
		{  20,  40 }, {  20,  10 }, {  29,   0 }, {  54,   0 },
		{  37,  42 }, {  12,  97 }, { -32, 127 }, { -22, 117 },
		{  -2,  74 }, {  -4,  85 }, { -24, 102 }, {   5,  57 },
		{  -6,  93 }, { -14,  88 }, {  -6,  44 }, {   4,  55 },

		/* 40 - 53 */
		{ -11,  89 },{ -15,  103 },{ -21,  116 },{  19,  57 },
		{  20,  58 },{   4,  84 },{   6,  96 },{   1,  63 },
		{  -5,  85 },{ -13,  106 },{   5,  63 },{   6,  75 },
		{  -3,  90 },{  -1,  101 },

		/* 54 - 59 */
		{   3,  55 },{  -4,  79 },{  -2,  75 },{ -12,  97 },
		{  -7,  50 },{   1,  60 },

		/* 60 - 69 */
		{ 0, 41 },   { 0, 63 },   { 0, 63 },     { 0, 63 },
		{ -9, 83 },  { 4, 86 },   { 0, 97 },     { -7, 72 },
		{ 13, 41 },  { 3, 62 },

		/* 70 - 104 */
		{   7,  34 }, {  -9,  88 }, { -20, 127 }, { -36, 127 },
		{ -17,  91 }, { -14,  95 }, { -25,  84 }, { -25,  86 },
		{ -12,  89 }, { -17,  91 }, { -31, 127 }, { -14,  76 },
		{ -18, 103 }, { -13,  90 }, { -37, 127 }, {  11,  80 },
		{   5,  76 }, {   2,  84 }, {   5,  78 }, {  -6,  55 },
		{   4,  61 }, { -14,  83 }, { -37, 127 }, {  -5,  79 },
		{ -11, 104 }, { -11,  91 }, { -30, 127 }, {   0,  65 },
		{  -2,  79 }, {   0,  72 }, {  -4,  92 }, {  -6,  56 },
		{   3,  68 }, {  -8,  71 }, { -13,  98 },

		/* 105 -> 165 */
		{  -4,  86 }, { -12,  88 }, {  -5,  82 }, {  -3,  72 },
		{  -4,  67 }, {  -8,  72 }, { -16,  89 }, {  -9,  69 },
		{  -1,  59 }, {   5,  66 }, {   4,  57 }, {  -4,  71 },
		{  -2,  71 }, {   2,  58 }, {  -1,  74 }, {  -4,  44 },
		{  -1,  69 }, {   0,  62 }, {  -7,  51 }, {  -4,  47 },
		{  -6,  42 }, {  -3,  41 }, {  -6,  53 }, {   8,  76 },
		{  -9,  78 }, { -11,  83 }, {   9,  52 }, {   0,  67 },
		{  -5,  90 }, {   1,  67 }, { -15,  72 }, {  -5,  75 },
		{  -8,  80 }, { -21,  83 }, { -21,  64 }, { -13,  31 },
		{ -25,  64 }, { -29,  94 }, {   9,  75 }, {  17,  63 },
		{  -8,  74 }, {  -5,  35 }, {  -2,  27 }, {  13,  91 },
		{   3,  65 }, {  -7,  69 }, {   8,  77 }, { -10,  66 },
		{   3,  62 }, {  -3,  68 }, { -20,  81 }, {   0,  30 },
		{   1,   7 }, {  -3,  23 }, { -21,  74 }, {  16,  66 },
		{ -23, 124 }, {  17,  37 }, {  44, -18 }, {  50, -34 },
		{ -22, 127 },

		/* 166 - 226 */
		{   4,  39 }, {   0,  42 }, {   7,  34 }, {  11,  29 },
		{   8,  31 }, {   6,  37 }, {   7,  42 }, {   3,  40 },
		{   8,  33 }, {  13,  43 }, {  13,  36 }, {   4,  47 },
		{   3,  55 }, {   2,  58 }, {   6,  60 }, {   8,  44 },
		{  11,  44 }, {  14,  42 }, {   7,  48 }, {   4,  56 },
		{   4,  52 }, {  13,  37 }, {   9,  49 }, {  19,  58 },
		{  10,  48 }, {  12,  45 }, {   0,  69 }, {  20,  33 },
		{   8,  63 }, {  35, -18 }, {  33, -25 }, {  28,  -3 },
		{  24,  10 }, {  27,   0 }, {  34, -14 }, {  52, -44 },
		{  39, -24 }, {  19,  17 }, {  31,  25 }, {  36,  29 },
		{  24,  33 }, {  34,  15 }, {  30,  20 }, {  22,  73 },
		{  20,  34 }, {  19,  31 }, {  27,  44 }, {  19,  16 },
		{  15,  36 }, {  15,  36 }, {  21,  28 }, {  25,  21 },
		{  30,  20 }, {  31,  12 }, {  27,  16 }, {  24,  42 },
		{   0,  93 }, {  14,  56 }, {  15,  57 }, {  26,  38 },
		{ -24, 127 },

		/* 227 - 275 */
		{ -24, 115 }, { -22,  82 }, {  -9,  62 }, {   0,  53 },
		{   0,  59 }, { -14,  85 }, { -13,  89 }, { -13,  94 },
		{ -11,  92 }, { -29, 127 }, { -21, 100 }, { -14,  57 },
		{ -12,  67 }, { -11,  71 }, { -10,  77 }, { -21,  85 },
		{ -16,  88 }, { -23, 104 }, { -15,  98 }, { -37, 127 },
		{ -10,  82 }, {  -8,  48 }, {  -8,  61 }, {  -8,  66 },
		{  -7,  70 }, { -14,  75 }, { -10,  79 }, {  -9,  83 },
		{ -12,  92 }, { -18, 108 }, {  -4,  79 }, { -22,  69 },
		{ -16,  75 }, {  -2,  58 }, {   1,  58 }, { -13,  78 },
		{  -9,  83 }, {  -4,  81 }, { -13,  99 }, { -13,  81 },
		{  -6,  38 }, { -13,  62 }, {  -6,  58 }, {  -2,  59 },
		{ -16,  73 }, { -10,  76 }, { -13,  86 }, {  -9,  83 },
		{ -10,  87 },

		/* 276 a bit special (not used, bypass is used instead) */
		{ 0, 0 },

		/* 277 - 337 */
		{ -22, 127 }, { -25, 127 }, { -25, 120 }, { -27, 127 },
		{ -19, 114 }, { -23, 117 }, { -25, 118 }, { -26, 117 },
		{ -24, 113 }, { -28, 118 }, { -31, 120 }, { -37, 124 },
		{ -10,  94 }, { -15, 102 }, { -10,  99 }, { -13, 106 },
		{ -50, 127 }, {  -5,  92 }, {  17,  57 }, {  -5,  86 },
		{ -13,  94 }, { -12,  91 }, {  -2,  77 }, {   0,  71 },
		{  -1,  73 }, {   4,  64 }, {  -7,  81 }, {   5,  64 },
		{  15,  57 }, {   1,  67 }, {   0,  68 }, { -10,  67 },
		{   1,  68 }, {   0,  77 }, {   2,  64 }, {   0,  68 },
		{  -5,  78 }, {   7,  55 }, {   5,  59 }, {   2,  65 },
		{  14,  54 }, {  15,  44 }, {   5,  60 }, {   2,  70 },
		{  -2,  76 }, { -18,  86 }, {  12,  70 }, {   5,  64 },
		{ -12,  70 }, {  11,  55 }, {   5,  56 }, {   0,  69 },
		{   2,  65 }, {  -6,  74 }, {   5,  54 }, {   7,  54 },
		{  -6,  76 }, { -11,  82 }, {  -2,  77 }, {  -2,  77 },
		{  25,  42 },

		/* 338 - 398 */
		{  17, -13 }, {  16,  -9 }, {  17, -12 }, {  27, -21 },
		{  37, -30 }, {  41, -40 }, {  42, -41 }, {  48, -47 },
		{  39, -32 }, {  46, -40 }, {  52, -51 }, {  46, -41 },
		{  52, -39 }, {  43, -19 }, {  32,  11 }, {  61, -55 },
		{  56, -46 }, {  62, -50 }, {  81, -67 }, {  45, -20 },
		{  35,  -2 }, {  28,  15 }, {  34,   1 }, {  39,   1 },
		{  30,  17 }, {  20,  38 }, {  18,  45 }, {  15,  54 },
		{   0,  79 }, {  36, -16 }, {  37, -14 }, {  37, -17 },
		{  32,   1 }, {  34,  15 }, {  29,  15 }, {  24,  25 },
		{  34,  22 }, {  31,  16 }, {  35,  18 }, {  31,  28 },
		{  33,  41 }, {  36,  28 }, {  27,  47 }, {  21,  62 },
		{  18,  31 }, {  19,  26 }, {  36,  24 }, {  24,  23 },
		{  27,  16 }, {  24,  30 }, {  31,  29 }, {  22,  41 },
		{  22,  42 }, {  16,  60 }, {  15,  52 }, {  14,  60 },
		{   3,  78 }, { -16, 123 }, {  21,  53 }, {  22,  56 },
		{  25,  61 },

		/* 399 - 435 */
		{  21,  33 }, {  19,  50 }, {  17,  61 },
		{  -3,  78 }, {  -8,  74 }, {  -9,  72 }, { -10,  72 },
		{ -18,  75 }, { -12,  71 }, { -11,  63 }, {  -5,  70 },
		{ -17,  75 }, { -14,  72 }, { -16,  67 }, {  -8,  53 },
		{ -14,  59 }, {  -9,  52 }, { -11,  68 }, {   9,  -2 },
		{  30, -10 }, {  31,  -4 }, {  33,  -1 }, {  33,   7 },
		{  31,  12 }, {  37,  23 }, {  31,  38 }, {  20,  64 },
		{  -9,  71 }, {  -7,  37 }, {  -8,  44 }, { -11,  49 },
		{ -10,  56 }, { -12,  59 }, {  -8,  63 }, {  -9,  67 },
		{  -6,  68 }, { -10,  79 },

		/* 436 - 459 */
		{  -3,  78 }, {  -8,  74 }, {  -9,  72 }, { -10,  72 },
		{ -18,  75 }, { -12,  71 }, { -11,  63 }, {  -5,  70 },
		{ -17,  75 }, { -14,  72 }, { -16,  67 }, {  -8,  53 },
		{ -14,  59 }, {  -9,  52 }, { -11,  68 }, {   9,  -2 },
		{  30, -10 }, {  31,  -4 }, {  33,  -1 }, {  33,   7 },
		{  31,  12 }, {  37,  23 }, {  31,  38 }, {  20,  64 },

		//Svc Stuff
		//Be carefull, should be a ctxIdx == 1024 to 1029
		/* 460 -> 466 */
		{  0,   75 }, {   2,  65 }, {   2,  59},
		{  -6,  67 }, {  -6,  67 }, { -23, 104 }, { -35, 106}
	}
};


//CABAC
unsigned char lps_range[64][4]= {{128,176,208,240}, {128,167,197,227}, {128,158,187,216}, {123,150,178,205},
{116,142,169,195}, {111,135,160,185}, {105,128,152,175}, {100,122,144,166},
{ 95,116,137,158}, { 90,110,130,150}, { 85,104,123,142}, { 81, 99,117,135},
{ 77, 94,111,128}, { 73, 89,105,122}, { 69, 85,100,116}, { 66, 80, 95,110},
{ 62, 76, 90,104}, { 59, 72, 86, 99}, { 56, 69, 81, 94}, { 53, 65, 77, 89},
{ 51, 62, 73, 85}, { 48, 59, 69, 80}, { 46, 56, 66, 76}, { 43, 53, 63, 72},
{ 41, 50, 59, 69}, { 39, 48, 56, 65}, { 37, 45, 54, 62}, { 35, 43, 51, 59},
{ 33, 41, 48, 56}, { 32, 39, 46, 53}, { 30, 37, 43, 50}, { 29, 35, 41, 48},
{ 27, 33, 39, 45}, { 26, 31, 37, 43}, { 24, 30, 35, 41}, { 23, 28, 33, 39},
{ 22, 27, 32, 37}, { 21, 26, 30, 35}, { 20, 24, 29, 33}, { 19, 23, 27, 31},
{ 18, 22, 26, 30}, { 17, 21, 25, 28}, { 16, 20, 23, 27}, { 15, 19, 22, 25},
{ 14, 18, 21, 24}, { 14, 17, 20, 23}, { 13, 16, 19, 22}, { 12, 15, 18, 21},
{ 12, 14, 17, 20}, { 11, 14, 16, 19}, { 11, 13, 15, 18}, { 10, 12, 15, 17},
{ 10, 12, 14, 16}, {  9, 11, 13, 15}, {  9, 11, 12, 14}, {  8, 10, 12, 14},
{  8,  9, 11, 13}, {  7,  9, 11, 12}, {  7,  9, 10, 12}, {  7,  8, 10, 11},
{  6,  8,  9, 11}, {  6,  7,  9, 10}, {  6,  7,  8,  9}, {  2,  2,  2,  2},
};

unsigned char mps_state[64]= {
	1, 2, 3, 4, 5, 6, 7, 8,
	9,10,11,12,13,14,15,16,
	17,18,19,20,21,22,23,24,
	25,26,27,28,29,30,31,32,
	33,34,35,36,37,38,39,40,
	41,42,43,44,45,46,47,48,
	49,50,51,52,53,54,55,56,
	57,58,59,60,61,62,62,63,
};

unsigned char lps_state[64]= {
	0, 0, 1, 2, 2, 4, 4, 5,
	6, 7, 8, 9, 9,11,11,12,
	13,13,15,15,16,16,18,18,
	19,19,21,21,22,22,23,24,
	24,25,26,26,27,27,28,29,
	29,30,30,30,31,32,32,33,
	33,33,34,34,35,35,35,36,
	36,36,37,37,37,38,38,63,
};




void CabacDecoderInitAVC(CABACContext *cabac, unsigned char *Data, const int *NalBytesInNalunit, 
						 int Pos, int slice_QP, int CabacContext[][2])
{

	int i;

	//CABAC
	init_cabac_states(cabac, lps_range,	mps_state, lps_state, 64);    
	init_cabac_decoder(cabac, Data +(Pos >> 3), *NalBytesInNalunit - ((Pos + 7) >> 3));
	for( i= 0; i < 460; i++ ) {
		int pre = ((CabacContext[i][0] * slice_QP) >> 4 ) + CabacContext[i][1];
		pre = CLIP3(1, 126, pre);       

		if( pre <= 63 ){
			cabac_state[i] = (unsigned char) (( 63 - pre ) << 1) + 0;
		} else{
			cabac_state[i] = (unsigned char) (( pre - 64 ) << 1) + 1;
		}
	}
}



/**
This function permits to decode the VLC for an intra image. 
All the parameters decoded will be stored in differents structures or tables.

@param data The NAL unit.
@param NalBytesInNalunit The sizes of the NAL unit in bytes.
@param sps The sps structure.
@param pps The pps structure.
@param Tab_block Contains all parameters of each macroblock of the current picture.
@param slice The slice structure contains all information used to decode the next slice.
@param aio_piPosition The current aio_piPosition in the NAL.
@param SliceTable Specifies in which slice belongs each macroblock of the picture.
@param picture_mb_type Specifies the type of each macroblock of the picture.
@param MbToSliceGroupMap Specifies in which slice belongs each macroblock of the picture.
@param end_of_slice Specifies if the current picture is totally decoded.
*/
char slice_data_I_cabac ( RESIDU *picture_residu, unsigned char *data, int *NalBytesInNalunit, 
						 SPS *sps, PPS *pps, DATA *block, SLICE *slice, int *aio_piPosition, 
						 unsigned char *SliceTable, unsigned char *MbToSliceGroupMap, int *EndOfSlice )
{

	//Initialization of the image parameters

	__declspec(align(64))  unsigned char non_zero_count_cache [48];
	CABAC_NEIGH param_neigh[1];
	CABACContext cabac[1];
	int slice_QP = slice -> slice_qp_delta;	
	volatile int  moreDataFlag = 1;
	int diff_qp = 0;

	short iCurrMbAddr = slice -> first_mb_in_slice;
	const short PicSizeInMbs = sps -> PicSizeInMbs ;
	const short PicWidthInMbs = sps -> pic_width_in_mbs;
	const short PicHeightInMbs = sps -> pic_height_in_map_units;
	short iMb_x;
	short iMb_y;
	unsigned char Last_Qp = slice -> slice_qp_delta;
	char ErrorDetection = 0;
	
	//initialize macroblock position
	GetMbPosition(iCurrMbAddr, PicWidthInMbs, &iMb_x, &iMb_y);

	//CABAC
	CabacDecoderInitAVC(cabac, data, NalBytesInNalunit, *aio_piPosition, slice_QP, cabac_context_init_I);


	//Decoding process macroblock per macroblock of one slice
	do {
		init_block(&block[iCurrMbAddr]);
		init_residu(&picture_residu[iCurrMbAddr]);
		picture_residu[iCurrMbAddr] . SliceNum = SliceTable [iCurrMbAddr] = slice -> slice_num ;
		GetNeighbour(iCurrMbAddr, iMb_x, PicWidthInMbs, PicSizeInMbs, SliceTable, picture_residu, 0);


		//Decoding process of the current macroblock
		ErrorDetection = macroblock_layer_I_cabac(&picture_residu[iCurrMbAddr], slice, block,
			non_zero_count_cache, SliceTable, iCurrMbAddr, cabac, cabac_state, param_neigh, iMb_x, 
			iMb_y, pps -> constrained_intra_pred_flag, pps -> transform_8x8_mode_flag, &Last_Qp, &diff_qp);


		//Recording of the neighbourhood for the decoding of the VLC 
		NonZeroCountManagement(non_zero_count_cache, iMb_x, iMb_y, PicWidthInMbs, PicHeightInMbs, 
			&block[iCurrMbAddr], &picture_residu[iCurrMbAddr]);


		//Updating of the macroblock parameters
		slice -> mb_xy++;
		moreDataFlag = !get_cabac_terminate(cabac, slice -> mb_xy, PicSizeInMbs);

		//Updating of the macroblock adress
		iCurrMbAddr = Next_MbAddress(iCurrMbAddr, PicSizeInMbs, PicWidthInMbs, MbToSliceGroupMap, &iMb_x, &iMb_y);

	} while ( moreDataFlag && !ErrorDetection);
	//To set endofslice according to the error detection.
	*EndOfSlice = EndOfSliceManagement(slice, PicSizeInMbs, ErrorDetection);

	return ErrorDetection;
}







/**
This function permits to decode the VLC for an P image. 
All the parameters decoded will be stored in differents structures or tables.
*/

char slice_data_P_cabac (RESIDU *picture_residu, unsigned char *data,int *NalBytesInNalunit, SPS *sps, 
						 PPS *pps, DATA *block, SLICE *slice,int *aio_piPosition, unsigned char *SliceTable, 
						 unsigned char *MbToSliceGroupMap, short *mv_cabac_l0, short *ref_cabac_l0,
						 int *EndOfSlice, short *mvl0_io, short *refl0_io)
{


	__declspec(align(64)) short mv_cache_l0[48][2];
	__declspec(align(64)) short mvl0_cache[48][2];
	__declspec(align(64)) short ref_cache_l0[48];
	__declspec(align(64)) short refl0_cache[48];
	__declspec(align(64)) unsigned char non_zero_count_cache [48];

	//Initialization of the image parameters	
	CABAC_NEIGH param_neigh[1];
	CABACContext cabac[1];

	int slice_QP = slice -> slice_qp_delta ;
	volatile int moreDataFlag = 1 ;
	int mb_skip_flag = 0 ;

	int diff_qp = 0;

	const short PicSizeInMbs = sps -> PicSizeInMbs ;
	const short PicWidthInMbs = sps -> pic_width_in_mbs;
	const short PicHeightInMbs = sps -> pic_height_in_map_units;
	short iCurrMbAddr = slice -> first_mb_in_slice;
	short iMb_x;
	short iMb_y;
	char ErrorDetection = 0;
	unsigned char Last_Qp = slice -> slice_qp_delta ;
	
	//initialize macroblock position
	GetMbPosition(iCurrMbAddr, PicWidthInMbs, &iMb_x, &iMb_y);



	//CABAC
	CabacDecoderInitAVC(cabac, data, NalBytesInNalunit, *aio_piPosition, slice_QP, &cabac_context_init_PB[slice -> cabac_init_idc][0]);


	//Decoding process macroblock per macroblock of one slice
	do {
		init_block(&block[iCurrMbAddr]);
		init_residu(&picture_residu[iCurrMbAddr]);
		picture_residu[iCurrMbAddr] . SliceNum = SliceTable [iCurrMbAddr] = slice -> slice_num ;
		GetNeighbour(iCurrMbAddr, iMb_x, PicWidthInMbs, PicSizeInMbs, SliceTable, picture_residu, 0);

		//Detection of a skipped macroblock
		mb_skip_flag = decode_cabac_mb_skip( cabac, cabac_state, picture_residu[iCurrMbAddr] . AvailMask, 
			SliceTable, picture_residu, slice -> slice_type, iCurrMbAddr, PicWidthInMbs);

		if (mb_skip_flag){
			diff_qp = 0;
			SkipP(slice, sps, picture_residu, block, SliceTable, iMb_x, iMb_y, PicSizeInMbs, 
				Last_Qp, mvl0_cache, refl0_cache, &mvl0_io [(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], 
				&refl0_io[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)]);

			init_mb_skip_mv_ref(&mv_cabac_l0[iMb_x * 8 + iMb_y * (PicWidthInMbs << 5)], 
				&ref_cabac_l0[iMb_x * 2 + iMb_y * (PicWidthInMbs << 2)], PicWidthInMbs << 3, PicWidthInMbs << 1);
		}
		else{
			//In case of there is more data in the NAL
			//to check if necessary
			init_ref_cache(ref_cache_l0);
			init_ref_cache(refl0_cache);
			init_mv_cache(mvl0_cache);
			init_mv_cache(mv_cache_l0);

			fill_caches_motion_vector( slice, PicWidthInMbs << 3, PicWidthInMbs << 1, ref_cache_l0, 
				mv_cache_l0, SliceTable, &picture_residu[iCurrMbAddr], 
				&mv_cabac_l0[iMb_x * 8 + iMb_y * (PicWidthInMbs << 5)], 
				&ref_cabac_l0[iMb_x * 2 + iMb_y * (PicWidthInMbs << 2)], iMb_x, iMb_y);

			fill_caches_motion_vector( slice, slice -> b_stride, slice -> b8_stride, refl0_cache, 
				mvl0_cache, SliceTable, &picture_residu[iCurrMbAddr], 
				&mvl0_io[(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], 
				&refl0_io[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)], iMb_x, iMb_y);


			//Decoding process of the current macroblock
			ErrorDetection = macroblock_layer_P_cabac(&picture_residu[iCurrMbAddr], slice, block, non_zero_count_cache, 
				SliceTable, iCurrMbAddr, cabac, cabac_state, param_neigh, mv_cache_l0, ref_cache_l0, 
				iMb_x, iMb_y, pps -> constrained_intra_pred_flag, pps -> transform_8x8_mode_flag, 
				&Last_Qp, &diff_qp, mvl0_cache, refl0_cache);


			//Recording of the neighbourhood for the decoding of the VLC 
			NonZeroCountManagement(non_zero_count_cache, iMb_x, iMb_y, PicWidthInMbs, PicHeightInMbs, 
				&block[iCurrMbAddr], &picture_residu[iCurrMbAddr]);

			write_back_motion(PicWidthInMbs << 3, PicWidthInMbs << 1, &mv_cabac_l0[iMb_x * 8 + iMb_y * (PicWidthInMbs << 5)], 
				mv_cache_l0, &ref_cabac_l0[iMb_x * 2 + iMb_y * (PicWidthInMbs << 2)], refl0_cache);

			//Recording of the motion vector
			write_back_motion(slice -> b_stride, slice -> b8_stride, &mvl0_io[(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], 
				mvl0_cache, &refl0_io[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)], refl0_cache);

		}
		//Save the last macroblock address
		slice -> mb_xy++;

		//Updating the macroblock adress
		iCurrMbAddr = Next_MbAddress(iCurrMbAddr, PicSizeInMbs, PicWidthInMbs, MbToSliceGroupMap, &iMb_x, &iMb_y);
		moreDataFlag = !get_cabac_terminate(cabac, slice -> mb_xy, PicSizeInMbs);

	} while ( moreDataFlag && !ErrorDetection);
	//To set endofslice according to the error detection.
	*EndOfSlice = EndOfSliceManagement(slice, PicSizeInMbs, ErrorDetection);

	return ErrorDetection;
}






/**
This function permits to decode the VLC for an B image. 
All the parameters decoded will be stored in differents structures or tables.

*/
char slice_data_B_cabac ( RESIDU *picture_residu, unsigned char *data,int *NalBytesInNalunit, SPS *sps, 
						 PPS *pps, DATA *block, SLICE *slice, int *aio_piPosition, unsigned char *SliceTable,
						 unsigned char *MbToSliceGroupMap, short *mv_cabac_l0, short *mv_cabac_l1, short *ref_cabac_l0, 
						 short *ref_cabac_l1, int *EndOfSlice, LIST_MMO * ai_pRefPicListL1, short *mvl0_io, 
						 short *mvl1_io, short *refl0_io, short *refl1_io, int long_term, int slice_type,
						 short *mvl1_l0, short *mvl1_l1, short *refl1_l0, short *refl1_l1)
{


	__declspec(align(64)) short mv_cache_l0[48][2];
	__declspec(align(64)) short mv_cache_l1[48][2];
	__declspec(align(64)) short ref_cache_l0[48];
	__declspec(align(64)) short ref_cache_l1[48];
	__declspec(align(64)) short mvl0_cache[48][2];
	__declspec(align(64)) short mvl1_cache[48][2];
	__declspec(align(64)) short refl0_cache[48];
	__declspec(align(64)) short refl1_cache[48];
	__declspec(align(64)) unsigned char non_zero_count_cache [48];

	//Initialization of the image parameters


	CABAC_NEIGH param_neigh[1];
	CABACContext cabac[1];
	int slice_QP = slice -> slice_qp_delta ;
	volatile int moreDataFlag = 1 ;
	int mb_skip_flag = 0 ;
	int diff_qp = 0;


	const short PicSizeInMbs =  sps -> PicSizeInMbs ;
	const short PicWidthInMbs =  sps -> pic_width_in_mbs;
	const short PicHeightInMbs = sps -> pic_height_in_map_units;
	short iCurrMbAddr = slice -> first_mb_in_slice;

	short iMb_x;
	short iMb_y;
	char ErrorDetection = 0;
	unsigned char Last_Qp = slice -> slice_qp_delta;
	
	//initialize macroblock position
	GetMbPosition(iCurrMbAddr, PicWidthInMbs, &iMb_x, &iMb_y);

	//CABAC
	CabacDecoderInitAVC(cabac,data, NalBytesInNalunit, *aio_piPosition, slice_QP, &cabac_context_init_PB[slice -> cabac_init_idc][0]);


	//Decoding process macroblock per macroblock of one slice
	do {
		init_block(&block[iCurrMbAddr]);
		init_residu(&picture_residu[iCurrMbAddr]);
		picture_residu[iCurrMbAddr] . SliceNum = SliceTable [iCurrMbAddr] = slice -> slice_num;
		GetNeighbour(iCurrMbAddr, iMb_x, PicWidthInMbs, PicSizeInMbs, SliceTable, picture_residu, 0);

		//Detection of a skipped macroblock
		mb_skip_flag = decode_cabac_mb_skip( cabac, cabac_state, picture_residu[iCurrMbAddr] . AvailMask, 
			SliceTable, picture_residu, slice -> slice_type, iCurrMbAddr, PicWidthInMbs);

		if (mb_skip_flag){
			//For CABAC decoding process
			diff_qp = 0;
			init_mb_skip_mv_ref(&mv_cabac_l0[iMb_x * 8 + iMb_y * (PicWidthInMbs << 5)]	, 
				&ref_cabac_l0[iMb_x * 2 + iMb_y * (PicWidthInMbs << 2)], PicWidthInMbs << 3, PicWidthInMbs << 1);
			init_mb_skip_mv_ref(&mv_cabac_l1[iMb_x * 8 + iMb_y * (PicWidthInMbs << 5)]	, 
				&ref_cabac_l1[iMb_x * 2 + iMb_y * (PicWidthInMbs << 2)], PicWidthInMbs << 3, PicWidthInMbs << 1);


			SkipB(slice, sps, picture_residu, block, SliceTable, iMb_x, iMb_y, Last_Qp, mv_cache_l0, ref_cache_l0, 
				&mvl0_io [(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], &refl0_io[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)]	, 
				mv_cache_l1, ref_cache_l1, &mvl1_io [(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], 
				&refl1_io[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)]	, &mvl1_l0[(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], 
				&mvl1_l1[(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], &refl1_l0[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)], 
				&refl1_l1[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)], ai_pRefPicListL1);


		} else {
			//In case of there is more data in the NAL

			init_ref_cache(ref_cache_l0);
			init_ref_cache(ref_cache_l1);
			init_ref_cache(refl0_cache);
			init_ref_cache(refl1_cache);
			init_mv_cache( mv_cache_l0);
			init_mv_cache( mv_cache_l1);
			init_mv_cache( mvl0_cache);
			init_mv_cache( mvl1_cache);


			fill_caches_motion_vector_B( slice, PicWidthInMbs << 3, PicWidthInMbs << 1, ref_cache_l0, ref_cache_l1, 
				mv_cache_l0, mv_cache_l1, SliceTable, &picture_residu[iCurrMbAddr], 
				&mv_cabac_l0[iMb_x * 8 + iMb_y * (PicWidthInMbs << 5)], &mv_cabac_l1[iMb_x * 8 + iMb_y * (PicWidthInMbs << 5)], 
				&ref_cabac_l0[iMb_x * 2 + iMb_y * (PicWidthInMbs << 2)], &ref_cabac_l1[iMb_x * 2 + iMb_y * (PicWidthInMbs << 2)], 
				iCurrMbAddr,iMb_x);

			fill_caches_motion_vector_B( slice, slice -> b_stride, slice -> b8_stride, refl0_cache, refl1_cache, 
				mvl0_cache, mvl1_cache, SliceTable, &picture_residu[iCurrMbAddr], 
				&mvl0_io[(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], &mvl1_io[(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)],
				&refl0_io[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)], &refl1_io[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)], 
				iCurrMbAddr, iMb_x);


			//Decoding process of the current macroblock
			ErrorDetection = macroblock_layer_B_cabac(&picture_residu[iCurrMbAddr], slice, block, non_zero_count_cache, SliceTable, 
				iCurrMbAddr, cabac, cabac_state, param_neigh, mv_cache_l0, mv_cache_l1, ref_cache_l0, ref_cache_l1, 
				iMb_x, iMb_y, pps -> constrained_intra_pred_flag , sps -> direct_8x8_inference_flag, 
				pps -> transform_8x8_mode_flag, &Last_Qp, &diff_qp, 0, mvl0_cache, mvl1_cache, refl0_cache, 
				refl1_cache, long_term, slice_type, &mvl1_l0[(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], 
				&mvl1_l1[(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], &refl1_l0[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)], 
				&refl1_l1[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)]);


			//Recording of the neighbourhood for the decoding of the VLC 
			NonZeroCountManagement(non_zero_count_cache, iMb_x, iMb_y, PicWidthInMbs, PicHeightInMbs, 
				&block[iCurrMbAddr], &picture_residu[iCurrMbAddr]);

			write_back_motion(PicWidthInMbs << 3, PicWidthInMbs << 1, &mv_cabac_l0[iMb_x * 8 + iMb_y * (PicWidthInMbs << 5)], 
				mv_cache_l0, &ref_cabac_l0[iMb_x * 2 + iMb_y * (PicWidthInMbs << 2)], ref_cache_l0);
			write_back_motion(PicWidthInMbs << 3, PicWidthInMbs << 1, &mv_cabac_l1[iMb_x * 8 + iMb_y * (PicWidthInMbs << 5)], 
				mv_cache_l1, &ref_cabac_l1[iMb_x * 2 + iMb_y * (PicWidthInMbs << 2)], ref_cache_l1);

			//Recording of the motion vector
			write_back_motion( slice -> b_stride, slice -> b8_stride, &mvl0_io[(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)],
				mvl0_cache, &refl0_io[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)], refl0_cache );
			write_back_motion( slice -> b_stride, slice -> b8_stride, &mvl1_io[(iMb_x << 3) + iMb_y * (slice -> b_stride << 2)], 
				mvl1_cache, &refl1_io[(iMb_x << 1) + iMb_y * (slice -> b8_stride << 1)], refl1_cache );
		}

		slice -> mb_xy++;
		//Updating the macroblock adress
		iCurrMbAddr = Next_MbAddress(iCurrMbAddr, PicSizeInMbs, PicWidthInMbs, MbToSliceGroupMap, &iMb_x, &iMb_y);
		moreDataFlag = !get_cabac_terminate(cabac, slice -> mb_xy, PicSizeInMbs);


	} while ( moreDataFlag && !ErrorDetection);
	//To set endofslice according to the error detection.
	*EndOfSlice = EndOfSliceManagement(slice, PicSizeInMbs, ErrorDetection);

	return ErrorDetection;
}
