#!/usr/bin/env bash

# install openvswitch 2.3.0 from pure
echo "Installing Open vSwitch ..."
wget http://openvswitch.org/releases/openvswitch-2.3.0.tar.gz
tar zxvf openvswitch-2.3.0.tar.gz
rm openvswitch-2.3.0.tar.gz
cd openvswitch-2.3.0  
./configure --with-linux=/lib/modules/`uname -r`/build
make
sudo make install
sudo make modules_install

echo "Remove the openvswitch module ..."
sudo rmmod openvswitch
sudo depmod -a

echo "Install new openvswitch module ..."
sudo /sbin/modprobe openvswitch

echo "Initial the conf.db"
sudo mkdir -p /usr/local/etc/openvswitch
sleep 1
# Check if there is file conf.db in /usr/local/etc/openvswitch, remove it.
sudo rm /usr/local/etc/openvswitch/conf.db
sudo ovsdb-tool create /usr/local/etc/openvswitch/conf.db vswitchd/vswitch.ovsschema
sleep 1
read -p "> Press Enter to continue" _start

echo "Start the ovs daemon ..."
sudo ovsdb-server --remote=punix:/usr/local/var/run/openvswitch/db.sock \
	     --remote=db:Open_vSwitch,Open_vSwitch,manager_options \
	     --private-key=db:Open_vSwitch,SSL,private_key \
	     --certificate=db:Open_vSwitch,SSL,certificate \
	     --bootstrap-ca-cert=db:Open_vSwitch,SSL,ca_cert \
	     --pidfile --detach
sleep 1
read -p "> Press Enter to continue" _start

sudo ovs-vsctl --no-wait init
sleep 1
read -p "> Press Enter to continue" _start
sudo ovs-vswitchd --pidfile --detach

