#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <crypt.h>
#include <omp.h>
char *hashed_str;

int main(int argc, char const *argv[])
{
	/* code */
	FILE *lib;
	lib = fopen("john.txt","r");
	if(lib == NULL){
	    fprintf(stderr,"cannot open library\nAbourt!\n");
	    exit(1);
	}
    	//read lib 
	char candidate[40][20];
	char buf[20];
	int count = 0;
	while( fscanf(lib,"%s\n",candidate[count]) == 1 ){
	    count++;
	}
	
	//read shadow
	if(argc < 1){
	    fprintf(stderr,"usage: decrypt <shadow file>\n");
	    exit(1);
	}
	FILE *fp; 
	fp = fopen(argv[1],"r");
	if(fp == NULL){
	    fprintf(stderr,"usage: decrypt <shadow file>\n");
	    exit(1);
	}
	char str[1024];
	while( fgets(str,1024,fp) != NULL){
	    //split the str
	    char *t_str = strtok(str,":");
	    hashed_str = strtok(NULL,":");
	    //split salt
	    int t = 0, i = 0;
	    char salt[1024];
	    while( t < 3 ){
		if(hashed_str[i] == '$')t++;
		i++;	
	    }
	    strncpy(salt,hashed_str,i);
	    salt[i] = '\0';
	    int isFound = 0;
	    struct crypt_data data;
	    //using brute force 
	    #pragma omp parallel for schedule(dynamic) num_threads(count)    
	    for(int i = 0; i < count; i++){
		if(isFound == 1)continue;
		for(int j = 0;j < count && !isFound; j++){
		    for(int k = 0; k < count && !isFound ; k++){
			if(i ^ j && j ^ k && k ^ i){ 
			    char key[20];
			    strcpy(key,candidate[i]);
			    strcat(key,candidate[j]);
			    strcat(key,candidate[k]);
			    
			    //crypt
			    data.initialized = 0;
			    
			    char *result = crypt_r(key, salt, &data);
			    #pragma omp flush(result)
			    if(strcmp( hashed_str, result ) == 0){ 
				isFound = 1;
				#pragma omp flush(isFound)
				printf("%s\n",key);
			    }   
			}   
		    }   
		}   
	    }   
	    if(!isFound)printf("Fail to find answer\n"); 
	}

	fclose(fp); 
	fclose(lib);
	return 0;
}


