#!/ bin/bash
echo "---------compile----------"
gcc lwc.c -o lwc
echo "--------------------------"

echo "Testing correctness ..."
RES=$( diff <(wc test1.txt -lwc) <(./lwc test1.txt -lwc))
if [ "$RES" == "" ]; then 
    echo "1. OK"
else 
    echo $RES
fi

#echo $RES
RES=$( diff <(wc test2.txt -l -wc) <(./lwc test2.txt -l -wc))
if [ "$RES" == "" ]; then 
    echo "2. OK"
fi

RES=$( diff <(wc test3.txt -lwc -l) <(./lwc test3.txt -lwc -l))
if [ "$RES" == "" ]; then 
    echo "3. OK"
fi

RES=$( diff <(wc test4.txt -cw -lc) <(./lwc test4.txt -lw -c))
if [ "$RES" == "" ]; then 
    echo "4. OK"
fi

echo "Testing invalid file input ... "
RES=$( diff <(wc test5.txt -lwc 2>&-) <(./lwc test5.txt -lwc 2>&-))
RES2=$( diff <(wc test5.txt -lwc 2>&1) <(./lwc test5.txt -lwc 2>&1))
if [ "$RES" == "" ] && [ "$RES2" == "" ]; then 
    echo "5. OK"
fi

echo "Testing format ..."
RES=$( diff <(wc test1.txt -l) <(./lwc test1.txt -l))
RES2=$( diff <(wc test1.txt -w) <(./lwc test1.txt -w))
RES3=$( diff <(wc test1.txt -c) <(./lwc test1.txt -c))
if [ "$RES" == "" ] && [ "$RES2" == "" ] && [ "$RES3" == "" ]; then 
    echo "6. OK"
fi

RES=$( diff <(wc test6.txt -lw) <(./lwc test6.txt -lw))
if [ "$RES" == "" ]; then 
    echo "7. OK"
fi

echo "Testing big file ..."
RES=$( diff <(wc test7.txt -l -w -c) <(./lwc test7.txt -l -w -c))
if [ "$RES" == "" ]; then 
    echo "8. OK"
fi

RES=$( diff <(wc test3.txt -lcc) <(./lwc test3.txt -ccl))
if [ "$RES" == "" ]; then 
    echo "9. OK"
fi

## invalid arguments 
echo "Tesing invalid argument"
RES=$( diff <(wc test4.txt -lwcg) <(./lwc test4.txt -lwcg))
if [ "$RES" == "" ]; then 
    echo "10. OK"
fi

echo "---check return value---"
./lwc test1.txt -lwc
echo $? 
./lwc not_existed.txt -lwc
echo $?
./lwc test3.txt -s 
echo $?





