/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import android.app.ActivityManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.Process;
import android.util.Log;
import com.android.tools.fd.runtime.AppInfo;
import com.android.tools.fd.runtime.Server;
import java.util.List;

public class InstantRunService
extends Service {
    private Server server;

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        Log.i((String)"InstantRun", (String)("Starting Instant Run Server for " + this.getPackageName()));
        super.onCreate();
        if (AppInfo.applicationId != null) {
            try {
                boolean startServer;
                boolean foundPackage = false;
                int pid = Process.myPid();
                ActivityManager manager = (ActivityManager)this.getSystemService("activity");
                List processes = manager.getRunningAppProcesses();
                if (processes != null && processes.size() > 1) {
                    startServer = false;
                    for (ActivityManager.RunningAppProcessInfo processInfo : processes) {
                        if (!AppInfo.applicationId.equals(processInfo.processName)) continue;
                        foundPackage = true;
                        if (processInfo.pid != pid) continue;
                        startServer = true;
                        break;
                    }
                    if (!startServer && !foundPackage) {
                        startServer = true;
                        if (Log.isLoggable((String)"InstantRun", (int)2)) {
                            Log.v((String)"InstantRun", (String)"Multiprocess but didn't find process with package: starting server anyway");
                        }
                    }
                } else {
                    startServer = true;
                }
                if (startServer) {
                    this.server = Server.create((Context)this);
                } else if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)"In secondary process: Not starting server");
                }
            }
            catch (Throwable t) {
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)"Failed during multi process check", (Throwable)t);
                }
                this.server = Server.create((Context)this);
            }
        } else {
            this.server = Server.create((Context)this);
        }
    }

    public void onDestroy() {
        if (this.server != null) {
            Log.i((String)"InstantRun", (String)("Stopping Instant Run Server for " + this.getPackageName()));
            this.server.shutdown();
        }
        super.onDestroy();
    }
}

